#define vec2 float2
#define vec4 float4
#define rgb xyz
#define rgba xyzw

typedef struct
{
	int width[8];
	int height[8];
	float cur_time;
	float total_time;
	float origROI[4];
	float resultROI[4];
	float angle;
}FilterParam;

const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_NEAREST;

static int get_global_id0(__global FilterParam* param)
{
	return get_global_id(0) - param->origROI[0]* param->width[0];
}

static int get_global_id1(__global FilterParam* param)
{
	return get_global_id(1) - param->origROI[1]* param->height[0];
}

vec4 INPUTSRC(image2d_t src_data, __global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, tc);
}
	
vec4 INPUT(image2d_t ovelay1,  __global FilterParam* param, vec2 tc)
{
	return read_imagef(ovelay1, sampler, (vec2)(tc.x,tc.y) );
}

	// Filter Valencia
__kernel void filter_Valencia(__read_only image2d_t image1,   	// image buffer 1
							  __read_only image2d_t image2,   	// image buffer 2
							  __read_only image2d_t image3,   	// image buffer 3
							  __write_only image2d_t retImg,  	// image buffer 4 for result
							  __private int alpha,
							  __global FilterParam* param)	 			// blend factor, scrope[0-100]	
{
	int w = get_global_id(0);
	int h = get_global_id(1);
	int width = get_image_width(image1);
	int height = get_image_height(image1);
	int W = get_global_size(0);
	int H = get_global_size(1);
	
	if(w >= width || h >= height)
			return;
	float2 resolution = (float2)(W,H);
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	vec2 uv = ((vec2)(fragCoord.x, fragCoord.y) + (vec2)(0.5f))/resolution.xy;
	
	float4 orig = INPUTSRC(image1, param, uv);
	float3 texel = orig.xyz; // rgb
	
	uv = (float2)(texel.x, 0.16666f);
	texel.x = INPUT(image2, param, uv).z;
	
	uv = (float2)(texel.y, 0.5f);
	texel.y = INPUT(image2, param, uv).y;
	
	uv = (float2)(texel.z, 0.83333f);
	texel.z = INPUT(image2, param, uv).x;
	
	texel.x = (1.1402f * texel.x) + (-0.1174f * texel.y) + (-0.0228f * texel.z);
	texel.y = (-0.0598f * texel.x) + (1.0826f * texel.y) + (-0.0228f * texel.z);
	texel.z = (-0.061f * texel.x) + (-0.1186f * texel.y) + (1.1772f * texel.z);

	float luma = dot((float3)(0.3f, 0.59f, 0.11f), texel);

	uv = (float2)(luma, texel.x);
	texel.x = INPUT(image3, param, uv).x;
	
	uv = (float2)(luma, texel.y);
	texel.y = INPUT(image3, param, uv).y;
	
	uv = (float2)(luma, texel.z);
	texel.z = INPUT(image3, param, uv).z;
	
	float4 newColor = (float4)(texel, orig.w);
	
	float factor = (float)(alpha)/100.0f;
	float4 color = (newColor * factor + orig * (1.0f - factor));		
	
	write_imagef(retImg, (int2)(w, h), color);
}


